import sys
from pathlib import Path

# Add nebuloid folder to Python path so import works
sys.path.append(str(Path(__file__).resolve().parent.parent / "nebuloid"))
print(str(Path(__file__).resolve().parent.parent / "nebuloid"))

from nebuloid import Nebuloid # type: ignore

neb = Nebuloid()
neb.manifest.from_file("shared/manifest.neb")

neb.init()


@neb.portal
async def view_orders(ctx):
    db = ctx.db
    user_id = ctx.user.get("user_id", None)  # current logged-in user ID
    print("Logged in user_id:", user_id)

    resp = await db.execute(
        "SELECT * FROM orders WHERE user_id = :user_id;",
        {"user_id": user_id}
    )

    # only return that user's orders
    return {"data": resp.get("data", [])}


@neb.portal
async def place_order(ctx):
    print("ctx.args:", ctx.args)
    orderid, order_name = ctx.args
    print(f"Placing order: {orderid}, {order_name}")
    db = ctx.db
    print(ctx.user.get("user_id", None))
    resp = await db.execute("INSERT INTO orders (user_id, order_id, name) VALUES (:user_id, :order_id, :name);", {"user_id": ctx.user.get("user_id", None), "order_id": orderid, "name": order_name})
    print("resp:", resp)
    return {"status": "Order placed successfully"}
@neb.portal
def add(ctx):
    x, y = ctx.args
    print(f"Adding {x} + {y}")
    return x+y

@neb.portal
def sub(ctx):
    x, y = ctx.args
    print(f"subract {x} - {y}")
    return {"result": x - y}

@neb.portal
def mul(ctx):
    x, y = ctx.args
    print(f"multiplay {x} * {y}")
    return {"result": x * y}

@neb.portal
def div(ctx):
    x, y = ctx.args
    if y == 0:
        return {"error": "Division by zero"}
    return {"result": x / y}

if __name__ == "__main__":
    neb.run()

